/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MyButton;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCube;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PlanRGBInterface;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.ServerAladin;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.ViewMemo;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;
import cds.aladin.Words;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.image.BMPWriter;
import cds.image.EPSGraphics;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import cds.xml.Field;
import cds.xml.XMLParser;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class Save
extends JFrame
implements ActionListener {
    static final String CR = cds.tools.Util.CR;
    static final String[] FORMAT = new String[]{"BMP", "EPS", "JPEG", "PNG", "PNG+LINK"};
    static final int BMP = 1;
    static final int EPS = 2;
    static final int JPEG = 4;
    static final int PNG = 8;
    static final int LK = 16;
    static final int LK_FLEX = 32;
    private static final int TSV = 0;
    private static final int JSON = 1;
    private static final int XML = 2;
    static final int CURRENTVIEW = 0;
    static final int ALLROIS = 2;
    static final int SAVEVIEW = 0;
    static final int EXPORTPLANS = 1;
    static final int BACKUPSTACK = 2;
    static final int ALLVIEWS = 3;
    Aladin aladin;
    JPanel p;
    static String[] INFOCHOICE;
    static String[] CHOICE;
    static String TITLE;
    static String INFO;
    static String FISTINFO;
    static String SECONDINFO;
    static String CLOSE;
    static String EXPORT;
    static String DIR;
    static String CANNOT;
    static String CANNOT1;
    static String INFOIMG;
    static String SAVEIN;
    static String SAVERGBIN;
    static String SAVEMOC;
    static String ENCODER;
    static String BROWSE;
    JTextField directory;
    JTextField[] fileSavePlan;
    Plan[] listPlan;
    int nbSavePlan;
    JComboBox format;
    JComboBox format1;
    JCheckBox[] cbPlan;
    JRadioButton tsvCb;
    JRadioButton votCb;
    JRadioButton jsonCb;
    JRadioButton jsonMocCb;
    JRadioButton asciiMocCb;
    JRadioButton fitsMocCb;
    JRadioButton fitsCb;
    JRadioButton jpgCb;
    JRadioButton pngCb;
    JLabel info;
    String errorFile = null;
    boolean first = true;
    private JFrame frameExport;
    boolean firstFlagFits = true;
    private static int MAXBUF;
    private static byte[] buf;
    private static int nbuf;
    private static FileOutputStream f;
    private static String B64;
    static int[] b642a;
    private static final String BYALADIN = "This astrometrical calibration was computed via Aladin";
    byte[] nan;
    final String COMPNG = "tEXtComment";

    protected static String[] getFormat() {
        return FORMAT;
    }

    protected static String[] getFormatMenu() {
        String[] res = new String[FORMAT.length - 1];
        int j = 0;
        for (int i = 0; i < FORMAT.length; ++i) {
            if (FORMAT[i].equals("EPS")) continue;
            res[j++] = "%" + FORMAT[i];
        }
        return res;
    }

    protected static int getCodedFormat(int n) {
        if (n < 4) {
            return (int)Math.pow(2.0, n);
        }
        return 24;
    }

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("SFTITLE");
        INFO = Aladin.chaine.getString("SFINFO");
        SECONDINFO = Aladin.chaine.getString("SFSECONDINFO");
        CLOSE = Aladin.chaine.getString("CLOSE");
        EXPORT = Aladin.chaine.getString("SFEXPORT");
        DIR = Aladin.chaine.getString("SFDIR");
        CANNOT = Aladin.chaine.getString("SFCANNOT");
        CANNOT1 = Aladin.chaine.getString("SFCANNOT1");
        INFOIMG = Aladin.chaine.getString("SFINFOIMG");
        SAVEIN = Aladin.chaine.getString("SFSAVEIN");
        SAVEMOC = Aladin.chaine.getString("SFSAVEMOCIN");
        SAVERGBIN = Aladin.chaine.getString("SFSAVERGBIN");
        ENCODER = Aladin.chaine.getString("SFJPEGENCODER");
        BROWSE = Aladin.chaine.getString("FILEBROWSE");
        if (Aladin.BETA) {
            String[] stringArray = new String[4];
            stringArray[0] = Aladin.chaine.getString("SFCH3");
            stringArray[1] = Aladin.chaine.getString("SFCH2");
            stringArray[2] = Aladin.chaine.getString("SFCH1");
            stringArray[3] = Aladin.chaine.getString("SFCH6");
            CHOICE = stringArray;
            String[] stringArray2 = new String[4];
            stringArray2[0] = Aladin.chaine.getString("SFHCH3");
            stringArray2[1] = Aladin.chaine.getString("SFHCH2");
            stringArray2[2] = Aladin.chaine.getString("SFHCH1");
            stringArray2[3] = Aladin.chaine.getString("SFHCH6");
            INFOCHOICE = stringArray2;
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = Aladin.chaine.getString("SFCH3");
            stringArray[1] = Aladin.chaine.getString("SFCH2");
            stringArray[2] = Aladin.chaine.getString("SFCH1");
            CHOICE = stringArray;
            String[] stringArray3 = new String[3];
            stringArray3[0] = Aladin.chaine.getString("SFHCH3");
            stringArray3[1] = Aladin.chaine.getString("SFHCH2");
            stringArray3[2] = Aladin.chaine.getString("SFHCH1");
            INFOCHOICE = stringArray3;
        }
    }

    protected Save(Aladin aladin) {
        this(aladin, false);
    }

    protected Save(Aladin aladin, boolean show) {
        this.aladin = aladin;
        this.suite();
        if (show) {
            this.show();
        }
    }

    protected void suite() {
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(TITLE);
        this.p = this.getFirstPanel();
        Aladin.makeAdd(this, this.p, "Center");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        cds.tools.Util.setCloseShortcut(this, false, this.aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.pack();
    }

    private JPanel getFirstPanel() {
        JPanel b = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 13;
        b.setLayout(g);
        b.setFont(Aladin.BOLD);
        for (int i = 0; i < CHOICE.length; ++i) {
            int j;
            MyLabel l;
            JPanel p;
            MyButton ml = new MyButton(this.aladin, CHOICE[i]);
            ml.setRond();
            c.gridwidth = -1;
            c.insets = new Insets(4, 5, 0, 3);
            g.setConstraints(ml, c);
            b.add(ml);
            if (i == 0) {
                p = new JPanel();
                l = new MyLabel(INFOCHOICE[i], 0, Aladin.PLAIN);
                p.add(l);
                this.format = new JComboBox();
                for (j = 0; j < FORMAT.length; ++j) {
                    this.format.addItem(FORMAT[j] + " format");
                }
                this.format.setSelectedIndex(3);
                p.add(this.format);
                c.gridwidth = 0;
                g.setConstraints(p, c);
                b.add(p);
                continue;
            }
            if (i == 3) {
                p = new JPanel();
                l = new MyLabel(INFOCHOICE[i], 0, Aladin.PLAIN);
                p.add(l);
                this.format1 = new JComboBox();
                for (j = 0; j < FORMAT.length; ++j) {
                    this.format1.addItem(FORMAT[j] + " format");
                }
                this.format1.setSelectedIndex(2);
                p.add(this.format1);
                c.gridwidth = 0;
                g.setConstraints(p, c);
                b.add(p);
                continue;
            }
            MyLabel l2 = new MyLabel(INFOCHOICE[i], 0, Aladin.PLAIN);
            c.gridwidth = 0;
            g.setConstraints(l2, c);
            b.add(l2);
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(5, 5));
        MyLabel info = new MyLabel(INFO, 1, Aladin.BOLD);
        Aladin.makeAdd(p, info, "North");
        Aladin.makeAdd(p, b, "Center");
        JPanel c1 = new JPanel();
        c1.setLayout(new BorderLayout());
        JButton bt = new JButton(CLOSE);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Save.this.hide();
            }
        });
        this.info = new JLabel();
        this.info.setFont(this.info.getFont().deriveFont(2));
        Aladin.makeAdd(c1, this.info, "Center");
        Aladin.makeAdd(c1, bt, "East");
        Aladin.makeAdd(p, c1, "South");
        return p;
    }

    protected void exportPlans() {
        this.frameExport = new JFrame();
        Aladin.makeAdd(this.frameExport, new MyLabel(SECONDINFO, 1, Aladin.BOLD), "North");
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 1));
        JPanel p1 = this.getPlanPanel();
        if (p1 == null) {
            return;
        }
        JScrollPane scroll = new JScrollPane(p1);
        int h = Math.min(400, this.aladin.calque.getNbUsedPlans() * 50 + 30);
        scroll.setMaximumSize(new Dimension(200, h));
        p.add(scroll);
        Aladin.makeAdd(this.frameExport, p, "Center");
        JPanel bas = new JPanel();
        bas.setLayout(new BorderLayout(5, 5));
        JPanel basg = new JPanel();
        this.directory = new JTextField(this.aladin.getDefaultDirectory(), 30);
        JButton b = new JButton(BROWSE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path;
                String initDir = Save.this.directory.getText();
                if (initDir.length() == 0) {
                    initDir = null;
                }
                if ((path = cds.tools.Util.dirBrowser("", initDir, Save.this.directory, 3)) != null) {
                    Save.this.directory.setText(path);
                }
            }
        });
        basg.add(new JLabel(DIR));
        basg.add(this.directory);
        basg.add(b);
        Aladin.makeAdd(bas, basg, "West");
        JPanel basd = new JPanel();
        basd.setLayout(new FlowLayout(1));
        JButton bt = new JButton(EXPORT);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Save.this.actionExportPlans();
            }
        });
        basd.add(bt);
        bt = new JButton(CLOSE);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Save.this.frameExportClose();
            }
        });
        basd.add(bt);
        Aladin.makeAdd(bas, basd, "Center");
        Aladin.makeAdd(this.frameExport, bas, "South");
        this.frameExport.pack();
        Point pos = this.getLocation();
        pos.translate(20, 40);
        this.frameExport.setLocation(pos);
        this.frameExport.setVisible(true);
    }

    private void frameExportClose() {
        this.frameExport.dispose();
    }

    protected void actionExportPlans() {
        boolean res = true;
        boolean flagFits = false;
        this.errorFile = "";
        block6: for (int i = 0; i < this.nbSavePlan; ++i) {
            if (!this.cbPlan[i].isSelected()) continue;
            Plan p = this.listPlan[i];
            File f = new File(this.directory.getText(), this.fileSavePlan[i].getText());
            this.aladin.console.printCommand("export " + Tok.quote(p.label) + " " + f.getAbsolutePath());
            switch (p.type) {
                case 19: 
                case 23: 
                case 24: {
                    String s = this.directory.getText() + cds.tools.Util.FS + this.fileSavePlan[i].getText();
                    res &= this.saveMoc(s, (PlanMoc)p, this.asciiMocCb != null && this.asciiMocCb.isSelected() ? 1 : (this.jsonMocCb != null && this.jsonMocCb.isSelected() ? 2 : 0));
                    continue block6;
                }
                case 9: {
                    if (p.isCatalog()) {
                        res &= this.saveCatalog(f, p, this.tsvCb.isSelected() ? 0 : (this.jsonCb != null && this.jsonCb.isSelected() ? 1 : 2));
                        continue block6;
                    }
                    res &= this.saveToolTSV(f, p);
                    continue block6;
                }
                case 8: 
                case 18: {
                    res &= this.saveCatalog(f, p, this.tsvCb.isSelected() ? 0 : (this.jsonCb != null && this.jsonCb.isSelected() ? 1 : 2));
                    continue block6;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    String s = this.directory.getText() + cds.tools.Util.FS + this.fileSavePlan[i].getText();
                    res &= this.saveImage(s, p, this.pngCb != null && this.pngCb.isSelected() ? 3 : (this.jpgCb != null && this.jpgCb.isSelected() ? 2 : 0));
                }
            }
        }
        if (!res) {
            Aladin.error(this, CANNOT + "\n " + this.errorFile, 1);
        } else {
            this.setVisible(false);
            if (flagFits && this.firstFlagFits) {
                this.firstFlagFits = false;
                Aladin.info(this, INFOIMG);
            }
            this.frameExportClose();
        }
        this.aladin.memoDefaultDirectory(this.directory.getText());
    }

    protected JPanel getPlanPanel() {
        ButtonGroup cg;
        JPanel pFormat;
        JLabel l;
        JLabel nil;
        int j = 0;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 0, 2);
        JPanel p = new JPanel();
        p.setLayout(g);
        int nb = this.aladin.calque.getNbUsedPlans();
        this.fileSavePlan = new JTextField[nb];
        this.cbPlan = new JCheckBox[nb];
        this.listPlan = new Plan[nb];
        boolean noCatalog = true;
        boolean noImage = true;
        boolean noMoc = true;
        Plan[] allPlan = this.aladin.calque.getPlans();
        for (int i = 0; i < allPlan.length; ++i) {
            Plan pl = allPlan[i];
            if (pl.type == 0 || pl.type == 10 || pl.type == 11 || !pl.flagOk || pl instanceof PlanBG && !pl.isMoc()) continue;
            if (pl.isSimpleCatalog() && noCatalog) {
                noCatalog = false;
            }
            if (pl.isImage() && noImage) {
                noImage = false;
            }
            if (pl instanceof PlanMoc && noMoc) {
                noMoc = false;
            }
            this.listPlan[j] = pl;
            this.cbPlan[j] = new JCheckBox(j + ".- ", pl.selected);
            String s = pl.label;
            JLabel name = new JLabel(s);
            name.setForeground(pl.c);
            JLabel type = new JLabel(Plan.Tp[pl.type]);
            String file = ServerAladin.blankToUnderline(s);
            while (file.charAt(0) == '.') {
                file = file.substring(1);
            }
            file = file.replace('\\', '-');
            file = file.replace('/', '-');
            file = file.replace(':', '-');
            file = file.replace('[', '-');
            file = file.replace(']', '-');
            file = pl.isImage() || pl.isMoc() ? cds.tools.Util.replaceExt(file, "fits") : cds.tools.Util.replaceExt(file, "txt");
            this.fileSavePlan[j] = new JTextField(file, 20);
            c.gridwidth = 2;
            c.anchor = 13;
            g.setConstraints(this.cbPlan[j], c);
            p.add(this.cbPlan[j]);
            c.gridwidth = 1;
            c.anchor = 17;
            g.setConstraints(name, c);
            p.add(name);
            c.gridwidth = 1;
            g.setConstraints(this.fileSavePlan[j], c);
            p.add(this.fileSavePlan[j]);
            c.gridwidth = 0;
            g.setConstraints(type, c);
            p.add(type);
            ++j;
        }
        if (j == 0) {
            Aladin.error(this, "There is no available plan to export !");
            return null;
        }
        if (!noCatalog) {
            c.gridwidth = 2;
            c.anchor = 13;
            nil = new JLabel("");
            g.setConstraints(nil, c);
            p.add(nil);
            c.gridwidth = 1;
            c.anchor = 17;
            l = new JLabel(SAVEIN);
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            pFormat = new JPanel();
            pFormat.setLayout(new FlowLayout(0));
            cg = new ButtonGroup();
            this.tsvCb = new JRadioButton("TSV");
            this.tsvCb.setActionCommand("TSV");
            this.votCb = new JRadioButton("VOTABLE");
            this.votCb.setActionCommand("VOTABLE");
            this.jsonCb = new JRadioButton("JSON");
            this.jsonCb.setActionCommand("JSON");
            cg.add(this.tsvCb);
            cg.add(this.votCb);
            cg.add(this.jsonCb);
            this.tsvCb.setSelected(true);
            pFormat.add(this.tsvCb);
            pFormat.add(this.votCb);
            pFormat.add(this.jsonCb);
            this.tsvCb.addActionListener(this);
            this.votCb.addActionListener(this);
            this.jsonCb.addActionListener(this);
            c.gridwidth = 1;
            if (!noImage || !noMoc) {
                c.gridwidth = 0;
            }
            g.setConstraints(pFormat, c);
            p.add(pFormat);
        }
        if (!noImage) {
            c.gridwidth = 2;
            c.anchor = 13;
            nil = new JLabel("");
            g.setConstraints(nil, c);
            p.add(nil);
            c.gridwidth = 1;
            c.anchor = 17;
            l = new JLabel(SAVERGBIN);
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            pFormat = new JPanel();
            pFormat.setLayout(new FlowLayout(0));
            cg = new ButtonGroup();
            this.fitsCb = new JRadioButton("FITS");
            this.fitsCb.setActionCommand("FITS");
            this.jpgCb = new JRadioButton("JPEG");
            this.jpgCb.setActionCommand("JPEG");
            this.pngCb = new JRadioButton("PNG");
            this.pngCb.setActionCommand("PNG");
            cg.add(this.fitsCb);
            cg.add(this.jpgCb);
            cg.add(this.pngCb);
            this.fitsCb.setSelected(true);
            pFormat.add(this.fitsCb);
            pFormat.add(this.jpgCb);
            pFormat.add(this.pngCb);
            this.fitsCb.addActionListener(this);
            this.jpgCb.addActionListener(this);
            this.pngCb.addActionListener(this);
            c.gridwidth = 1;
            c.insets.top = 2;
            c.insets.bottom = 2;
            if (!noMoc) {
                c.gridwidth = 0;
            }
            g.setConstraints(pFormat, c);
            p.add(pFormat);
        }
        if (!noMoc) {
            c.gridwidth = 2;
            c.anchor = 13;
            nil = new JLabel("");
            g.setConstraints(nil, c);
            p.add(nil);
            c.gridwidth = 1;
            c.anchor = 17;
            l = new JLabel(SAVEMOC);
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            pFormat = new JPanel();
            pFormat.setLayout(new FlowLayout(0));
            cg = new ButtonGroup();
            this.fitsMocCb = new JRadioButton("FITS");
            this.fitsMocCb.setActionCommand("FITS");
            this.asciiMocCb = new JRadioButton("ASCII");
            this.asciiMocCb.setActionCommand("ASCII");
            this.jsonMocCb = new JRadioButton("JSON");
            this.jsonMocCb.setActionCommand("JSON");
            cg.add(this.fitsMocCb);
            cg.add(this.jsonMocCb);
            cg.add(this.asciiMocCb);
            this.fitsMocCb.setSelected(true);
            pFormat.add(this.fitsMocCb);
            pFormat.add(this.asciiMocCb);
            pFormat.add(this.jsonMocCb);
            this.fitsMocCb.addActionListener(this);
            this.asciiMocCb.addActionListener(this);
            this.jsonMocCb.addActionListener(this);
            c.gridwidth = 1;
            c.gridwidth = 0;
            g.setConstraints(pFormat, c);
            p.add(pFormat);
        }
        this.nbSavePlan = j;
        return p;
    }

    protected void saveFile(int mode) {
        this.saveFile(mode, 1, -1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFile(int mode, int format, float qual) {
        boolean res;
        FileDialog fd = new FileDialog((Frame)this, "", 1);
        this.aladin.setDefaultDirectory(fd);
        fd.setVisible(true);
        this.aladin.memoDefaultDirectory(fd);
        String dir = fd.getDirectory();
        String name = fd.getFile();
        if (name == null) {
            return;
        }
        String s = (dir == null ? "" : dir) + (name == null ? "" : name);
        Aladin.makeCursor(this, 1);
        try {
            if (mode == 0) {
                if (!cds.tools.Util.toLower(s).endsWith(".aj")) {
                    s = s + ".aj";
                }
                this.aladin.console.printCommand("backup " + s);
                res = this.saveAJ(s);
                if (res) {
                    this.aladin.log("backup", "");
                }
            } else if (mode == 2) {
                this.aladin.console.printCommand("save -allviews " + s);
                final String s1 = s;
                final int format1 = format;
                new Thread(){

                    @Override
                    public void run() {
                        boolean ok = Save.this.saveAllViews(s1, format1);
                        if (!ok) {
                            Save.this.info("Save error !!!");
                        } else {
                            Save.this.setVisible(false);
                        }
                    }
                }.start();
                res = true;
            } else {
                String ext;
                String string = format == 1 ? ".bmp" : (format == 4 ? ".jpg" : (ext = (format & 8) == 8 ? ".png" : ".eps"));
                if (!(cds.tools.Util.toLower(s).endsWith(".jpeg") && format == 4 || cds.tools.Util.toLower(s).endsWith(ext))) {
                    s = s + ext;
                }
                String lk = (format & 0x10) == 16 ? " -lk" : "";
                this.aladin.console.printCommand("save " + lk + s);
                res = this.saveView(s, 0, 0, format, qual);
                if (res) {
                    this.aladin.log("save", cds.tools.Util.toUpper(ext.substring(1) + lk));
                }
            }
        }
        finally {
            Aladin.makeCursor(this, 0);
        }
        if (!res) {
            Aladin.error(this, CANNOT + "\n" + s + "\n" + CANNOT1, 1);
        } else if (mode != 2) {
            this.setVisible(false);
            this.aladin.memoLastFile(s);
        }
    }

    private static void open(File file) throws IOException {
        f = new FileOutputStream(file);
        nbuf = 0;
    }

    private static void flush() throws IOException {
        f.write(buf, 0, nbuf);
        nbuf = 0;
    }

    private static void close() throws IOException {
        Save.flush();
        f.close();
    }

    private static void append(String s) throws IOException {
        Save.append(s.toCharArray());
    }

    private static void append(char[] a) throws IOException {
        for (int i = 0; i < a.length; ++i) {
            Save.buf[Save.nbuf++] = (byte)a[i];
            if (nbuf != MAXBUF) continue;
            Save.flush();
        }
    }

    protected boolean saveAJ(String filename) {
        filename = this.aladin.getFullFileName(filename);
        File file = new File(filename);
        Plan[] allPlan = this.aladin.calque.getPlans();
        try {
            file.delete();
            Save.open(file);
            Save.append("<?xml version = \"1.0\"?>\n<!-- This file has been produced by the Aladin Java interface," + CR + "     Please do not modify it -->" + CR + CR + "<ALADINJAVA vers=\"1.0\">" + CR);
            block12: for (int i = allPlan.length - 1; i >= 0; --i) {
                Plan p = allPlan[i];
                if (!p.isReady()) continue;
                switch (p.type) {
                    case 19: 
                    case 23: 
                    case 24: {
                        this.appendPlanMOCXML(p);
                        continue block12;
                    }
                    case 16: 
                    case 18: 
                    case 22: {
                        this.appendPlanBGXML(p);
                        continue block12;
                    }
                    case 12: {
                        this.appendPlanFilterXML(p);
                        continue block12;
                    }
                    case 11: {
                        this.appendPlanFolderXML(p);
                        continue block12;
                    }
                    case 8: {
                        this.appendPlanCatalogXML(p);
                        continue block12;
                    }
                    case 9: {
                        this.appendPlanToolXML(p);
                        continue block12;
                    }
                    case 1: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.appendPlanImageXML(p);
                        continue block12;
                    }
                    case 2: {
                        this.appendPlanImageRGBXML(p);
                    }
                }
            }
            this.aladin.view.sauvegarde();
            Save.append("  <MODEVIEW");
            Save.append(CR + "    reticle=\"" + this.aladin.view.repere.raj + " " + this.aladin.view.repere.dej + "\"");
            Save.append(CR + "    overlays=\"" + this.aladin.calque.getOverlayList() + "\"");
            Save.append(CR + "    overlay=\"" + this.aladin.calque.flagOverlay + "\"");
            Save.append(CR + "    mode=\"" + this.aladin.view.getModeView() + "\"");
            Save.append(CR + "    position=\"" + this.aladin.view.getScrollValue() + "\">" + CR);
            for (int j = 0; j < this.aladin.view.viewMemo.size(); ++j) {
                if (this.aladin.view.viewMemo.memo[j] == null || this.aladin.view.viewMemo.memo[j].pref == null) continue;
                Save.append("    <VIEW n=\"" + j + "\"");
                this.appendView(this.aladin.view.viewMemo.memo[j]);
                Save.append(">" + CR + "    </VIEW>" + CR);
            }
            Save.append("  </MODEVIEW>" + CR);
            Save.append("</ALADINJAVA>" + CR);
            Save.close();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error(this, CANNOT + "\n" + file + "\n--> " + e, 1);
            return false;
        }
        return true;
    }

    private void appendView(ViewMemoItem m) {
        try {
            Save.append(CR + "       zoom=\"" + m.zoom + "\"");
            Save.append(CR + "       xzoomView=\"" + m.xzoomView + "\"");
            Save.append(CR + "       yzoomView=\"" + m.yzoomView + "\"");
            Save.append(CR + "       rzoomWidth=\"" + m.rzoomWidth + "\"");
            Save.append(CR + "       rzoomHeight=\"" + m.rzoomHeight + "\"");
            Save.append(CR + "       rvWidth=\"" + m.rvWidth + "\"");
            Save.append(CR + "       rvHeight=\"" + m.rvHeight + "\"");
            Save.append(CR + "       pref=\"" + m.pref.label + "\"");
            Save.append(CR + "       locked=\"" + m.locked + "\"");
            Save.append(CR + "       northUp=\"" + m.northUp + "\"");
            if (!Double.isNaN(m.jdmin)) {
                Save.append(CR + "       jdMin=\"" + m.jdmin + "\"");
            }
            if (!Double.isNaN(m.jdmax)) {
                Save.append(CR + "       jdMax=\"" + m.jdmax + "\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeMocFormat() {
        String newSuffix = this.asciiMocCb.isSelected() ? "txt" : (this.jsonMocCb.isSelected() ? "json" : "fits");
        for (int i = 0; i < this.listPlan.length; ++i) {
            Plan p = this.listPlan[i];
            if (p == null || !(p instanceof PlanMoc)) continue;
            String label = this.fileSavePlan[i].getText();
            this.fileSavePlan[i].setText(cds.tools.Util.replaceExt(label, newSuffix));
        }
    }

    private void changeCatFormat() {
        String newSuffix = this.tsvCb.isSelected() ? "txt" : (this.jsonCb != null && this.jsonCb.isSelected() ? "json" : "xml");
        for (int i = 0; i < this.listPlan.length; ++i) {
            Plan p = this.listPlan[i];
            if (p == null || !p.isCatalog()) continue;
            String label = this.fileSavePlan[i].getText();
            this.fileSavePlan[i].setText(cds.tools.Util.replaceExt(label, newSuffix));
        }
    }

    private void changeImgFormat() {
        String newSuffix = this.fitsCb.isSelected() ? "fits" : (this.jpgCb.isSelected() ? "jpg" : "png");
        for (int i = 0; i < this.listPlan.length; ++i) {
            Plan p = this.listPlan[i];
            if (p == null || !p.isImage()) continue;
            String label = this.fileSavePlan[i].getText();
            this.fileSavePlan[i].setText(cds.tools.Util.replaceExt(label, newSuffix));
        }
    }

    private void appendPlanImageRGBXML(Plan p) throws IOException {
        this.appendXMLHeadPlan(p);
        Save.append("    <VALUE><![CDATA[" + CR);
        this.append64(((PlanImageRGB)p).getByteRGB());
        Save.append("]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    private void appendPlanImageXML(Plan p) throws IOException {
        this.appendXMLHeadPlan(p);
        Save.append("    <VALUE><![CDATA[" + CR);
        this.append64(((PlanImage)p).getBufPixels8());
        Save.append("]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    public static int get64(byte[] b, int k, char[] a, int start, int length) {
        int i;
        char[] tab = B64.toCharArray();
        int size = b.length;
        if (b642a == null) {
            b642a = new int[256];
            for (i = 0; i < b642a.length; ++i) {
                Save.b642a[i] = 64;
            }
            for (i = 0; i < tab.length; ++i) {
                Save.b642a[tab[i]] = i;
            }
            Save.b642a[61] = 255;
        }
        int colno = 0;
        boolean skip_line = false;
        int lineno = 1;
        int j = start;
        while (j < length) {
            int c = a[j++];
            ++colno;
            if (skip_line && Aladin.levelTrace >= 3) {
                System.err.print(c);
            }
            if (c == 32 || c == 9 || c == 10 || c == 13) {
                if (c != 10 && c != 13) continue;
                ++lineno;
                colno = 0;
                skip_line = false;
                continue;
            }
            if (skip_line) continue;
            int c3 = b642a[c & 0xFF];
            if ((c3 & 0x40) != 0) {
                if (colno == 1) {
                    skip_line = true;
                    if (Aladin.levelTrace < 3) continue;
                    System.err.println("++++Ignore line: " + c);
                    continue;
                }
                if (Aladin.levelTrace < 3) continue;
                System.err.println("****Bad input char (1) " + (char)c + " line " + lineno + ", col " + colno);
                continue;
            }
            c3 <<= 6;
            c = a[j++] & 0xFF;
            ++colno;
            i = b642a[c & 0xFF];
            if ((i & 0x40) != 0) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("****Bad input char (2) " + (char)c + " line " + lineno + ", col " + colno);
                }
                c3 >>>= 4;
                if (k >= size) {
                    return k;
                }
                b[k++] = (byte)c3;
                continue;
            }
            c3 |= i;
            c3 <<= 6;
            c = a[j++] & 0xFF;
            ++colno;
            i = b642a[c & 0xFF];
            if ((i & 0x40) != 0) {
                if (i != 255 && Aladin.levelTrace >= 3) {
                    System.err.println("****Bad input char (3) " + (char)c + " line " + lineno + ", col " + colno);
                }
                c3 >>>= 2;
                if (k >= size) {
                    return k;
                }
                b[k++] = (byte)(c3 >>> 8);
                if (k >= size) {
                    return k;
                }
                b[k++] = (byte)c3;
                continue;
            }
            c3 |= i;
            c3 <<= 6;
            c = a[j++] & 0xFF;
            ++colno;
            i = b642a[c & 0xFF];
            if ((i & 0x40) != 0 && i != 255) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("****Bad input char (4) " + (char)c + " line " + lineno + ", col " + colno);
                }
            } else {
                c3 |= i;
            }
            if (k >= size) {
                return k;
            }
            b[k++] = (byte)(c3 >>> 16);
            if (k >= size) {
                return k;
            }
            b[k++] = (byte)(c3 >>> 8);
            if (k >= size) {
                return k;
            }
            b[k++] = (byte)c3;
        }
        return k;
    }

    private void append64(byte[] p) throws IOException {
        char[] tab = B64.toCharArray();
        char[] b4 = new char[4];
        int i = 0;
        int nb = 0;
        while (i < p.length) {
            int c = p[i++] & 0xFF;
            int c3 = c << 16;
            b4[3] = 61;
            b4[2] = 61;
            if (i < p.length) {
                c = p[i++] & 0xFF;
                c3 |= c << 8;
                b4[2] = '\u0000';
                if (i < p.length) {
                    c = p[i++] & 0xFF;
                    c3 |= c;
                    b4[3] = '\u0000';
                }
            }
            if (b4[3] == '\u0000') {
                b4[3] = tab[c3 & 0x3F];
            }
            c3 >>= 6;
            if (b4[2] == '\u0000') {
                b4[2] = tab[c3 & 0x3F];
            }
            b4[1] = tab[(c3 >>= 6) & 0x3F];
            b4[0] = tab[(c3 >>= 6) & 0x3F];
            Save.append(b4);
            if ((nb += 4) % 76 != 0) continue;
            Save.append(CR);
        }
    }

    private void appendGenericCommand(Plan p) throws IOException {
        String cmd = p.getBookmarkCode();
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        this.appendXMLHeadPlan(p);
        Save.append("    <VALUE><![CDATA[" + cmd + "]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    private void appendPlanCatalogXML(Plan p) throws IOException {
        this.appendXMLHeadPlan(p);
        this.appendPCatXML(p.pcat);
        Save.append("  </PLANE>" + CR);
    }

    private void appendPCatXML(Pcat pcat) throws IOException {
        Legende leg = null;
        Iterator<Obj> it = pcat.iterator();
        while (it.hasNext()) {
            Obj o1 = it.next();
            if (!o1.asSource()) continue;
            Source o = (Source)o1;
            if (o.getLeg() != leg) {
                if (leg != null) {
                    Save.append(this.getXMLTailTable());
                }
                Save.append(this.getXMLHeadTable(o, o.getLeg()));
                leg = o.getLeg();
            }
            Source po = o;
            Save.append(po.raj + "\t" + po.dej + "\t" + po.id);
            Save.append("\t" + o.info + CR);
        }
        if (pcat.hasObj()) {
            Save.append(this.getXMLTailTable());
        }
    }

    protected void appendPlanMOCXML(Plan p) throws Exception {
        this.appendXMLHeadPlan(p);
        Save.append("    <TABLE><VALUE><![CDATA[" + CR);
        Moc moc = ((PlanMoc)p).getMoc();
        Save.append(moc.toASCII());
        Save.append(CR);
        Save.append("]]></VALUE></TABLE>" + CR);
        Save.append("  </PLANE>" + CR);
    }

    protected void appendPlanBGXML(Plan p) throws IOException {
        this.appendXMLHeadPlan(p);
        Save.append("  </PLANE>" + CR);
    }

    protected void appendPlanFilterXML(Plan p) throws IOException {
        this.appendXMLHeadPlan(p);
        Save.append("    <SCRIPT>" + CR);
        Save.append(XMLParser.XMLEncode(((PlanFilter)p).script.replaceAll("\n", "\\\\n")) + CR);
        Save.append("    </SCRIPT>" + CR);
        Save.append("  </PLANE>" + CR);
    }

    protected void appendPlanFolderXML(Plan p) throws IOException {
        this.appendXMLHeadPlan(p);
        Save.append("  </PLANE>" + CR);
    }

    protected void appendPlanToolXML(Plan p) throws IOException {
        boolean flagSource = false;
        this.appendXMLHeadPlan(p);
        Save.append("    <TABLE><VALUE><![CDATA[" + CR);
        Iterator<Obj> it = p.pcat.iterator();
        while (it.hasNext()) {
            Position o = (Position)it.next();
            if (o.asSource()) {
                flagSource = true;
                continue;
            }
            if (o instanceof Cercle) {
                Cercle c = (Cercle)o;
                Save.append(this.getInstance(c) + "\t.\t" + c.o[0].raj + "\t" + c.o[0].dej + "\t" + c.o[0].x + "\t" + c.o[0].y + "\t" + c.isWithLabel() + "\t" + c.getSpecificAJInfo() + CR);
                Save.append(this.getInstance(c) + "\t+\t" + c.o[1].raj + "\t" + c.o[1].dej + "\t" + c.o[1].x + "\t" + c.o[1].y + "\t" + c.isWithLabel() + "\t" + c.getSpecificAJInfo() + CR);
                continue;
            }
            Save.append(this.getInstance(o) + "\t" + this.suite(o) + "\t" + o.raj + "\t" + o.dej + "\t" + o.x + "\t" + o.y + "\t" + o.isWithLabel() + "\t" + o.getSpecificAJInfo() + CR);
        }
        Save.append(this.getXMLTailTable());
        if (flagSource) {
            this.appendPCatXML(p.pcat);
        }
        Save.append("  </PLANE>" + CR);
    }

    protected String getToolName(Obj o) {
        return "Undefined";
    }

    protected String getXMLTailTable() {
        return "]]></VALUE></TABLE>" + CR;
    }

    protected String getXMLHeadTable(Source o, Legende leg) {
        StringBuilder s = new StringBuilder();
        s.append("    <TABLE>" + CR);
        int fovIdx = o.getIdxFootprint();
        for (int i = 0; i < leg.field.length; ++i) {
            Field f = leg.field[i];
            s.append("      <COLUMN");
            if (f.name != null) {
                s.append(CR + "         name=\"" + XMLParser.XMLEncode(f.name) + "\"");
            }
            if (f.description != null) {
                s.append(CR + "         description=\"" + XMLParser.XMLEncode(f.description) + "\"");
            }
            if (f.href != null) {
                s.append(CR + "         href=\"" + XMLParser.XMLEncode(f.href) + "\"");
            }
            if (f.gref != null) {
                s.append(CR + "         gref=\"" + XMLParser.XMLEncode(f.gref) + "\"");
            }
            if (f.ucd != null) {
                s.append(CR + "         ucd=\"" + XMLParser.XMLEncode(f.ucd) + "\"");
            }
            if (f.unit != null) {
                s.append(CR + "         unit=\"" + XMLParser.XMLEncode(f.unit) + "\"");
            }
            if (f.width != null) {
                s.append(CR + "         width=\"" + XMLParser.XMLEncode(f.width) + "\"");
            }
            if (f.nullValue != null) {
                s.append(CR + "         nullValue=\"" + XMLParser.XMLEncode(f.nullValue) + "\"");
            }
            if (f.arraysize != null) {
                s.append(CR + "         arraysize=\"" + XMLParser.XMLEncode(f.arraysize) + "\"");
            }
            if (f.precision != null) {
                s.append(CR + "         precision=\"" + XMLParser.XMLEncode(f.precision) + "\"");
            }
            if (f.utype != null) {
                s.append(CR + "         utype=\"" + XMLParser.XMLEncode(f.utype) + "\"");
            }
            if (f.xtype != null) {
                s.append(CR + "         xtype=\"" + XMLParser.XMLEncode(f.xtype) + "\"");
            }
            if (f.type != null) {
                s.append(CR + "         type=\"" + XMLParser.XMLEncode(f.type) + "\"");
            }
            if (f.datatype != null) {
                s.append(CR + "         datatype=\"" + XMLParser.XMLEncode(f.datatype) + "\"");
            }
            if (f.refText != null) {
                s.append(CR + "         refText=\"" + XMLParser.XMLEncode(f.refText) + "\"");
            }
            if (f.refValue != null) {
                s.append(CR + "         refValue=\"" + XMLParser.XMLEncode(f.refValue) + "\"");
            }
            if (f.sed != 0) {
                s.append(CR + "         sed=\"" + XMLParser.XMLEncode(f.getSEDtag()) + "\"");
            }
            if (i == fovIdx) {
                s.append(CR + "         sregion=\"true\"");
            }
            s.append("/>" + CR);
        }
        s.append("      <VALUE><![CDATA[" + CR);
        return s.toString();
    }

    private void appendXMLHeadPlan(Plan p) throws IOException {
        PlanImage pi;
        Save.append("  <PLANE");
        Save.append(CR + "     type=\"" + XMLParser.XMLEncode(Plan.Tp[p.type]) + "\"");
        Save.append(CR + "     depth=\"" + p.folder + "\"");
        Save.append(CR + "     activated=\"" + p.active + "\"");
        if (p.label != null) {
            Save.append(CR + "     label=\"" + XMLParser.XMLEncode(p.label) + "\"");
        }
        if (p.id != null) {
            Save.append(CR + "     id=\"" + XMLParser.XMLEncode(p.id) + "\"");
        }
        if (p.objet != null) {
            Save.append(CR + "     object=\"" + XMLParser.XMLEncode(p.objet) + "\"");
        }
        if (p.body != null) {
            Save.append(CR + "     body=\"" + XMLParser.XMLEncode(p.body) + "\"");
        }
        if (p.param != null) {
            Save.append(CR + "     param=\"" + XMLParser.XMLEncode(p.param) + "\"");
        }
        if (p.type == 12 && ((PlanFilter)p).plan != null) {
            Save.append(CR + "     dedicatedto=\"" + ((PlanFilter)p).plan.label + "\"");
        }
        if (p.type == 11) {
            Save.append(CR + "     localscope=\"" + ((PlanFolder)p).localScope + "\"");
        }
        if (!p.isImage() && p.type != 11 && p.type != 12) {
            Save.append(CR + "     color=\"" + Action.findColorName(p.c) + "\"");
        }
        if (p.type == 9 && ((PlanTool)p).isCatalog()) {
            Save.append(CR + "     withsource=\"true\"");
        }
        if (p.isCatalog()) {
            String shape = Source.TYPENAME[p.sourceType];
            Save.append(CR + "     shape=\"" + shape + "\"");
            if (p.hasNoPos) {
                Save.append(CR + "     nopos=\"" + p.hasNoPos + "\"");
            }
        }
        if (p.getScalingFactor() != 1.0f) {
            Save.append(CR + "     scalingfactor=\"" + p.getScalingFactor() + "\"");
        }
        if (!p.isSelectable()) {
            Save.append(CR + "     selectable=\"false\"");
        }
        if (p.isImage()) {
            pi = (PlanImage)p;
            String fmt = PlanImage.getFormat(pi.fmt);
            String res = PlanImage.getResolution(pi.res);
            Save.append(CR + "     fmt=\"" + XMLParser.XMLEncode(fmt) + "\"");
            Save.append(CR + "     resolution=\"" + XMLParser.XMLEncode(res) + "\"");
        }
        if (p.copyright != null) {
            Save.append(CR + "     from=\"" + XMLParser.XMLEncode(p.copyright) + "\"");
        }
        if (p.u != null) {
            Save.append(CR + "     url=\"" + XMLParser.XMLEncode(p.u + "") + "\"");
        }
        if (Projection.isOk(p.projd)) {
            Save.append(CR + "     RA=\"" + p.projd.raj + "\"");
            Save.append(CR + "     DE=\"" + p.projd.dej + "\"");
            Save.append(CR + "     radius=\"" + p.projd.rm / 2.0 + "\"");
            Save.append(CR + "     proj=\"" + p.projd.modeCalib + "\"");
            if (Projection.isOk(p.projd)) {
                int i;
                Calib c = p.projd.c;
                Save.append(CR + "     calib=\"" + c.aladin + "," + c.epoch + "," + c.alpha + "," + c.delta + "," + c.yz + "," + c.xz + "," + c.focale + "," + c.Xorg + "," + c.Yorg + "," + c.incX + "," + c.incY + "," + c.alphai + "," + c.deltai + "," + c.incA + "," + c.incD + "," + c.Xcen + "," + c.Ycen + "," + c.widtha + "," + c.widthd + "," + c.xnpix + "," + c.ynpix + "," + c.rota + "," + c.cdelz + "," + c.sdelz + "," + c.type1 + "," + c.type2 + "," + c.equinox + "," + c.proj + "\"");
                Save.append(CR + "     projection=\"" + Calib.getProjName(c.proj) + "\"");
                Save.append(CR + "     system=\"" + c.system + "\"");
                Save.append(CR + "     flagepoch=\"" + c.flagepoc + "\"");
                Save.append(CR + "     adxpoly=\"" + c.adxpoly[0]);
                for (i = 1; i < c.adxpoly.length; ++i) {
                    Save.append("," + c.adxpoly[i]);
                }
                Save.append("\"");
                Save.append(CR + "     adypoly=\"" + c.adypoly[0]);
                for (i = 1; i < c.adypoly.length; ++i) {
                    Save.append("," + c.adypoly[i]);
                }
                Save.append("\"");
                Save.append(CR + "     xyapoly=\"" + c.xyapoly[0]);
                for (i = 1; i < c.xyapoly.length; ++i) {
                    Save.append("," + c.xyapoly[i]);
                }
                Save.append("\"");
                Save.append(CR + "     xydpoly=\"" + c.xydpoly[0]);
                for (i = 1; i < c.xydpoly.length; ++i) {
                    Save.append("," + c.xydpoly[i]);
                }
                Save.append("\"");
                Save.append(CR + "     CD=\"" + c.CD[0][0] + "," + c.CD[0][1] + "," + c.CD[1][0] + "," + c.CD[1][1] + "\"");
                Save.append(CR + "     ID=\"" + c.ID[0][0] + "," + c.ID[0][1] + "," + c.ID[1][0] + "," + c.ID[1][1] + "\"");
            }
        }
        if (p instanceof PlanImage) {
            pi = (PlanImage)p;
            Save.append(CR + "     width=\"" + pi.width + "\"");
            Save.append(CR + "     height=\"" + pi.height + "\"");
            Save.append(CR + "     video=\"" + pi.video + "\"");
            Save.append(CR + "     transfertFct=\"" + pi.getTransfertFct() + "\"");
            Save.append(CR + "     minPix=\"" + pi.dataMin + "\"");
            Save.append(CR + "     maxPix=\"" + pi.dataMax + "\"");
            Save.append(CR + "     minPixCut=\"" + pi.pixelMin + "\"");
            Save.append(CR + "     maxPixCut=\"" + pi.pixelMax + "\"");
            Save.append(CR + "     bZero=\"" + pi.bZero + "\"");
            Save.append(CR + "     bScale=\"" + pi.bScale + "\"");
            Save.append(CR + "     cm=\"" + pi.typeCM + "\"");
            Save.append(CR + "     colormap1=\"" + pi.cmControl[0] + "\"");
            Save.append(CR + "     colormap2=\"" + pi.cmControl[1] + "\"");
            Save.append(CR + "     colormap3=\"" + pi.cmControl[2] + "\"");
            Save.append(CR + "     bitpix=\"" + pi.bitpix + "\"");
            Save.append(CR + "     opacity=\"" + pi.getOpacityLevel() + "\"");
            if (pi.cacheID != null && pi.cacheOffset != 0L) {
                Save.append(CR + "     cacheID=\"" + XMLParser.XMLEncode(pi.cacheID) + "\"");
                Save.append(CR + "     cacheOffset=\"" + pi.cacheOffset + "\"");
            }
            if (p instanceof PlanImageRGB) {
                PlanImageRGB prgb = (PlanImageRGB)pi;
                for (int j = 0; j < 9; ++j) {
                    Save.append(CR + "     RGBControl" + (j + 1) + "=\"" + prgb.RGBControl[j] + "\"");
                }
                if (prgb.planRed != null && prgb.planRed.type != 0) {
                    Save.append(CR + "     RGBRed=\"" + prgb.planRed.label + "\"");
                }
                if (prgb.planGreen != null && prgb.planGreen.type != 0) {
                    Save.append(CR + "     RGBGreen=\"" + prgb.planGreen.label + "\"");
                }
                if (prgb.planBlue != null && prgb.planBlue.type != 0) {
                    Save.append(CR + "     RGBBlue=\"" + prgb.planBlue.label + "\"");
                }
            }
            if (p instanceof PlanBG) {
                PlanBG pbg = (PlanBG)p;
                if (pbg.gluTag != null) {
                    Save.append(CR + "     hipsgluTag=\"" + pbg.gluTag + "\"");
                }
                if (pbg.survey != null) {
                    Save.append(CR + "     hipssurvey=\"" + pbg.survey + "\"");
                }
                if (pbg.url != null) {
                    Save.append(CR + "     hipsurl=\"" + pbg.url + "\"");
                }
                Save.append(CR + "     hipsminOrder=\"" + pbg.minOrder + "\"");
                Save.append(CR + "     hipsmaxOrder=\"" + pbg.maxOrder + "\"");
                Save.append(CR + "     hipscube=\"" + pbg.cube + "\"");
                Save.append(CR + "     hipscolor=\"" + pbg.color + "\"");
                Save.append(CR + "     hipscolorPNG=\"" + pbg.colorPNG + "\"");
                Save.append(CR + "     hipscolorUnknown=\"" + pbg.colorUnknown + "\"");
                Save.append(CR + "     hipsfitsGzipped=\"" + pbg.fitsGzipped + "\"");
                Save.append(CR + "     hipstruePixels=\"" + pbg.truePixels + "\"");
                Save.append(CR + "     hipsinFits=\"" + pbg.inFits + "\"");
                Save.append(CR + "     hipsinJPEG=\"" + pbg.inJPEG + "\"");
                Save.append(CR + "     hipsinPNG=\"" + pbg.inPNG + "\"");
                Save.append(CR + "     hipshasMoc=\"" + pbg.hasMoc + "\"");
                Save.append(CR + "     hipshasHpxFinder=\"" + pbg.hasHpxFinder + "\"");
                Save.append(CR + "     hipsframeOrigin=\"" + pbg.frameOrigin + "\"");
                Save.append(CR + "     hipsframeDrawing=\"" + pbg.frameDrawing + "\"");
                Save.append(CR + "     hipslive=\"" + pbg.live + "\"");
                if (pbg.pixelCut != null) {
                    Save.append(CR + "     hipspixelCut=\"" + pbg.pixelCut + "\"");
                }
                Save.append(CR + "     hipstransferFct4Fits=\"" + pbg.transferFct4Fits + "\"");
                Save.append(CR + "     hipstransferFct4Preview=\"" + pbg.transferFct4Preview + "\"");
                Save.append(CR + "     hipstileOrder=\"" + pbg.tileOrder + "\"");
                if (p instanceof PlanBGCube) {
                    Save.append(CR + "     hipsdepth=\"" + ((PlanBGCube)pbg).depth + "\"");
                }
            }
        }
        Save.append(" >" + CR);
        if (p.filters != null) {
            Save.append("    <FILTERS filterIndex=\"" + p.filterIndex + "\" nFilter=\"" + p.filters.length + "\">" + CR);
            for (int j = 0; j < p.filters.length; ++j) {
                Save.append("       <FILTER><![CDATA[");
                Save.append(p.filters[j] + CR);
                Save.append("]]></FILTER>" + CR);
            }
            Save.append("    </FILTERS>" + CR);
        }
        if (p instanceof PlanCatalog && ((PlanCatalog)p).isRedoable()) {
            PlanCatalog p1 = (PlanCatalog)p;
            String code = p1.getBookmarkCode();
            String query = p1.getAdqlQuery();
            Save.append("    <REDO>" + CR);
            if (code != null) {
                Save.append("       <REDOCODE><![CDATA[" + code + "]]></REDOCODE>" + CR);
            }
            if (query != null) {
                Save.append("      <REDOQUERY><![CDATA[" + query + "]]></REDOQUERY>" + CR);
            }
            Save.append("    </REDO>" + CR);
        }
        if (p instanceof PlanImage && ((PlanImage)p).hasFitsHeader()) {
            Save.append("    <ORIRIGINALHEADERFITS>" + CR);
            Save.append("    <![CDATA[");
            Save.append(((PlanImage)p).headerFits.getOriginalHeaderFits());
            Save.append("]]>" + CR);
            Save.append("    </ORIRIGINALHEADERFITS>" + CR);
        }
    }

    protected boolean saveCatalog(String s, Plan p, boolean tsv, boolean addCoo, boolean addXY) {
        s = this.aladin.getFullFileName(s);
        File f = new File(s);
        boolean rep = tsv ? this.saveCatTSV(f, p) : this.saveCatVOTable(f, p, addCoo, addXY);
        if (rep) {
            this.aladin.memoLastFile(s);
        }
        return rep;
    }

    protected boolean saveCatalog(File file, Plan p, int mode) {
        if (mode == 0) {
            return this.saveCatTSV(file, p);
        }
        if (mode == 1) {
            return this.saveCatJSON(file, p);
        }
        return this.saveCatVOTable(file, p, false, false);
    }

    private File nextSuffixFile(File file, int n) {
        int j;
        String f = file.getAbsolutePath();
        int i = f.lastIndexOf(46);
        f = i >= 0 ? ((j = f.lastIndexOf(45, i)) > 0 ? f.substring(0, j) + "-" + n + f.substring(i) : f.substring(0, i) + "-" + n + f.substring(i)) : f + "-" + n;
        return new File(f);
    }

    private String getInstance(Object o) {
        if (o instanceof Tag) {
            return "taglabel";
        }
        if (o instanceof Cote) {
            return "arrow";
        }
        if (o instanceof Ligne) {
            return "line";
        }
        if (o instanceof Repere) {
            return "tag";
        }
        if (o instanceof SourceStat) {
            return "phot";
        }
        if (o instanceof Source) {
            return "source";
        }
        if (o instanceof Cercle) {
            return "circle";
        }
        return "unknown";
    }

    private String suite(Obj o) {
        if (o instanceof Ligne) {
            if (((Ligne)o).finligne == null) {
                return ((Ligne)o).bout == 3 ? "*" : ".";
            }
            return "+";
        }
        return ".";
    }

    protected boolean saveToolTSV(File file, Plan p) {
        StringBuilder s = new StringBuilder(MAXBUF);
        Pcat pcat = p.pcat;
        FileOutputStream f = null;
        try {
            s.append("Object\tCont_Flag\tRAJ2000\tDEJ2000\tX\tY\tLabel_Flag\tInfo" + CR);
            Iterator<Obj> it = pcat.iterator();
            int nb = pcat.getCount();
            for (int i = 0; i <= nb; ++i) {
                if (i < nb) {
                    Position o = (Position)it.next();
                    if (o instanceof Cercle) {
                        Cercle c = (Cercle)o;
                        s.append(this.getInstance(c) + "\t.\t" + c.o[0].raj + "\t" + c.o[0].dej + "\t" + c.o[0].x + "\t" + c.o[0].y + "\t" + c.isWithLabel() + "\t" + c.getSpecificAJInfo() + CR);
                        s.append(this.getInstance(c) + "\t+\t" + c.o[1].raj + "\t" + c.o[1].dej + "\t" + c.o[1].x + "\t" + c.o[1].y + "\t" + c.isWithLabel() + "\t" + c.getSpecificAJInfo() + CR);
                    } else {
                        s.append(this.getInstance(o) + "\t" + this.suite(o) + "\t" + o.raj + "\t" + o.dej + "\t" + o.x + "\t" + o.y + "\t" + o.isWithLabel() + "\t" + o.getSpecificAJInfo() + CR);
                    }
                }
                if (s.length() <= MAXBUF - 100 && i != nb) continue;
                f = this.writeByteTSV(f, file, 0, s);
                s = new StringBuilder(MAXBUF);
            }
        }
        catch (Exception e) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "tool TSV");
        return true;
    }

    protected boolean saveCatTSV(File file, Plan p) {
        StringBuilder s = new StringBuilder(MAXBUF);
        Pcat pcat = p.pcat;
        int nbTable = 0;
        FileOutputStream f = null;
        try {
            Legende leg = ((PlanCatalog)p).getFirstLegende();
            s.append(this.getShortHeader(leg));
            int nb = pcat.getCount();
            Iterator<Obj> it = pcat.iterator();
            for (int i = 0; i <= nb; ++i) {
                Source o = (Source)(i < nb ? it.next() : null);
                if (o == null || o.getLeg() != leg) {
                    if (i < nb) {
                        s.append(CR);
                    }
                    f = this.writeByteTSV(f, file, nbTable, s);
                    if (o == null) {
                        f.close();
                        f = null;
                    }
                    ++nbTable;
                    if (o != null) {
                        s = new StringBuilder(MAXBUF);
                        leg = o.getLeg();
                        s.append(this.getShortHeader(leg));
                    }
                }
                if (o != null) {
                    s.append(Save.getTSV(o) + CR);
                }
                if (s.length() <= MAXBUF) continue;
                f = this.writeByteTSV(f, file, nbTable, s);
                s = new StringBuilder(MAXBUF);
            }
        }
        catch (Exception e) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "catalog TSV");
        return true;
    }

    protected boolean saveCatJSON(File file, Plan p) {
        StringBuilder s = new StringBuilder(MAXBUF);
        Pcat pcat = p.pcat;
        int nbTable = 0;
        FileOutputStream f = null;
        boolean first = true;
        try {
            s.append("[" + CR);
            Legende leg = ((PlanCatalog)p).getFirstLegende();
            s.append("[");
            int nb = pcat.getCount();
            Iterator<Obj> it = pcat.iterator();
            for (int i = 0; i <= nb; ++i) {
                Source o = (Source)(i < nb ? it.next() : null);
                if (o == null || o.getLeg() != leg) {
                    s.append(CR + "]" + CR);
                    if (o == null) {
                        s.append("]" + CR);
                    }
                    f = this.writeByteTSV(f, file, nbTable, s);
                    if (o == null) {
                        f.close();
                        f = null;
                    } else {
                        first = true;
                    }
                    ++nbTable;
                    if (o != null) {
                        s = new StringBuilder(MAXBUF);
                        leg = o.getLeg();
                        s.append("," + CR + "[");
                    }
                }
                if (o != null) {
                    if (!first) {
                        s.append(",");
                    }
                    s.append(CR);
                    s.append("   " + Save.getJSON(leg, o));
                    first = false;
                }
                if (s.length() <= MAXBUF) continue;
                f = this.writeByteTSV(f, file, nbTable, s);
                s = new StringBuilder(MAXBUF);
            }
        }
        catch (Exception e) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "catalog JSON");
        return true;
    }

    private FileOutputStream writeByteTSV(FileOutputStream f, File file, int nbTable, StringBuilder s) throws Exception {
        if (f == null) {
            if (nbTable > 0) {
                file = this.nextSuffixFile(file, nbTable);
            }
            file.delete();
            f = new FileOutputStream(file);
        }
        char[] a = s.toString().toCharArray();
        byte[] b = new byte[a.length];
        for (int j = 0; j < a.length; ++j) {
            b[j] = (byte)a[j];
        }
        f.write(b);
        return f;
    }

    protected boolean saveCatVOTable(File file, Plan p, boolean addCoo, boolean addXY) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.aladin.writePlaneInVOTable(p, out, addCoo, addXY);
            out.close();
        }
        catch (IOException ioe) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "catalog VOTABLE");
        return true;
    }

    protected void ImageWriter(Image img, String format, float qual, boolean RGB, OutputStream o) throws Exception {
        try {
            if (format.equals("jpg") || format.equals("jpeg")) {
                this.writeJPEG(img, qual, RGB, o);
            } else {
                BufferedImage bufferedImage;
                if (img instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)img;
                } else {
                    bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), RGB ? 1 : 10);
                    Graphics2D g = bufferedImage.createGraphics();
                    g.drawImage(img, 0, 0, this.aladin);
                    g.dispose();
                }
                this.aladin.waitImage(bufferedImage);
                ImageIO.write((RenderedImage)bufferedImage, format, o);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw new Exception(ENCODER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJPEG(Image img, float qual, boolean RGB, OutputStream os) throws Exception {
        BufferedImage bufferedImage;
        if (img instanceof BufferedImage) {
            bufferedImage = (BufferedImage)img;
        } else {
            bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), RGB ? 2 : 10);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(img, 0, 0, this.aladin);
            g.dispose();
        }
        this.aladin.waitImage(img);
        if (qual < 0.0f || qual > 1.0f) {
            qual = 0.95f;
        }
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(qual);
        try (ImageOutputStream out = null;){
            out = ImageIO.createImageOutputStream(os);
            writer.setOutput(out);
            writer.write(null, new IIOImage(bufferedImage, null, null), iwp);
            writer.dispose();
        }
    }

    protected boolean saveView(String filename, int w, int h, int format, float qual) {
        return this.saveView(filename, w, h, format, qual, 0);
    }

    protected boolean saveView(String filename, int w, int h, int format, float qual, int mode) {
        if (mode != 0) {
            System.err.println("Presently, only the current view can be saved");
            return false;
        }
        return this.saveOneView(filename, w, h, format, qual, this.aladin.view.getCurrentView());
    }

    protected boolean saveAllViews(String prefix, int fmt) {
        boolean res = false;
        try {
            if (prefix == null || prefix.trim().length() == 0) {
                prefix = "ROI";
            }
            ViewSimple v = new ViewSimple(this.aladin, this.aladin.view, 0, 0, 0);
            this.aladin.view.sauvegarde();
            ViewMemo viewMemo = this.aladin.view.viewMemo.copy();
            Rectangle rv = new Rectangle(0, 0, this.aladin.view.viewSimple[0].rv.width, this.aladin.view.viewSimple[0].rv.height);
            int n = viewMemo.size();
            for (int i = 0; i < n; ++i) {
                if (viewMemo.get(i, v) == null || v.isFree() || !v.pref.isPixel()) continue;
                v.rv = rv;
                v.setSize(rv.width, rv.height);
                if (v.pref instanceof PlanBG) {
                    v.pref.projd = v.projLocal;
                }
                v.setZoomXY(v.zoom, v.xzoomView, v.yzoomView);
                v.newView(1);
                String name = prefix + cds.tools.Util.align3(i + 1) + (fmt == 1 ? ".bmp" : (fmt == 8 ? ".png" : ".jpg"));
                this.info("Saving " + (i + 1) + "/" + n + " " + cds.tools.Util.getShortPath(name, 40) + "...");
                res = this.saveOneView(name, -1, -1, fmt, -1.0f, v) || res;
            }
            v.free();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            res = false;
        }
        return res;
    }

    private void info(String s) {
        this.info.setText(s + " ");
    }

    protected boolean saveOneView(String filename, int w, int h, int format, float qual, ViewSimple v) {
        boolean rep;
        block2: {
            rep = false;
            try {
                rep = this.saveOneView1(filename, w, h, format, qual, v);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveOneView1(String filename, int w, int h, int format, float qual, ViewSimple v) throws Exception {
        boolean rep = false;
        OutputStream o = null;
        try {
            OutputStream outputStream = o = filename == null ? System.out : new FileOutputStream(this.aladin.getFullFileName(filename));
            if ((format & 2) == 2) {
                this.saveEPS(v, w, h, o);
            } else {
                String s;
                Image img = v.getImage(w, h);
                if ((format & 4) == 4) {
                    s = this.generateFitsHeaderString(v);
                    this.ImageWriter(img, "jpg", qual, true, new JpegOutputFilter(o, s));
                } else if ((format & 8) == 8) {
                    s = this.generateFitsHeaderString(v);
                    this.ImageWriter(img, "png", -1.0f, true, new PNGOutputFilter(o, s));
                } else if ((format & 1) == 1) {
                    BMPWriter.write(img, o);
                } else {
                    throw new Exception("Unsupported output image format !");
                }
            }
            rep = true;
        }
        catch (Exception e) {
            if (filename != null) {
                System.out.println("!!! image error [" + filename + "]");
            }
            System.err.println(e.getMessage());
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
        }
        finally {
            if (o != null && o != System.out) {
                o.close();
            }
        }
        Aladin.trace(3, "Current view saved successfully " + this.aladin.getFullFileName(filename));
        if (((format & 0x10) == 16 || (format & 0x20) == 32) && filename != null) {
            boolean lkFlex = (format & 0x20) == 32;
            try {
                int i = filename.lastIndexOf(46);
                if (i >= 0) {
                    filename = filename.substring(0, i);
                }
                String linkFilename = filename + (lkFlex ? ".lkflex" : ".lk");
                o = new FileOutputStream(this.aladin.getFullFileName(linkFilename));
                this.linkWriter(v, o, lkFlex);
                Projection proj = v.pref.projd;
                if (lkFlex) {
                    String cornersFilename = filename + ".corners";
                    FileOutputStream oCorners = new FileOutputStream(this.aladin.getFullFileName(cornersFilename));
                    PrintStream out = new PrintStream(oCorners);
                    PointD pp = v.getPosition(0.0, 0.0);
                    Coord coo1 = new Coord();
                    coo1.x = pp.x;
                    coo1.y = pp.y;
                    proj.getCoord(coo1);
                    pp = v.getPosition(0.0, (double)v.rv.height);
                    Coord coo2 = new Coord();
                    coo2.x = pp.x;
                    coo2.y = pp.y;
                    proj.getCoord(coo2);
                    pp = v.getPosition((double)v.rv.width, (double)v.rv.height);
                    Coord coo3 = new Coord();
                    coo3.x = pp.x;
                    coo3.y = pp.y;
                    proj.getCoord(coo3);
                    pp = v.getPosition((double)v.rv.width, 0.0);
                    Coord coo4 = new Coord();
                    coo4.x = pp.x;
                    coo4.y = pp.y;
                    proj.getCoord(coo4);
                    out.print("# C0 0.0 0.0 " + coo1.al + " " + coo1.del + "\n");
                    out.print("# C1 0.0 " + v.rv.height + " " + coo2.al + " " + coo2.del + "\n");
                    out.print("# C2 " + v.rv.width + " " + v.rv.height + " " + coo3.al + " " + coo3.del + "\n");
                    out.print("# C3 " + v.rv.width + " 0.0 " + coo4.al + " " + coo4.del + "\n");
                    out.flush();
                    out.close();
                }
                Aladin.trace(3, "HTTP link file generated [" + linkFilename + "]");
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
            }
            finally {
                o.close();
            }
        }
        return rep;
    }

    protected void linkWriter(ViewSimple v, OutputStream o, boolean flex) throws Exception {
        PrintStream out = new PrintStream(o);
        out.print("#PLANE\tID\tX\tY\tURL\n");
        Plan[] plan = this.aladin.calque.getPlans();
        Plan folder = this.aladin.calque.getMyScopeFolder(plan, v.pref);
        for (int i = plan.length - 1; i >= 0; --i) {
            Plan p = plan[i];
            if (!p.isSimpleCatalog() || !p.flagOk) continue;
            boolean flagDraw = i >= v.n;
            boolean bl = flagDraw = flagDraw && this.aladin.calque.getMyScopeFolder(plan, p) == folder;
            if (p.pcat == null || !p.active && !flex) continue;
            if (!flex) {
                p.pcat.writeLink(out, v, flagDraw);
                continue;
            }
            p.pcat.writeLinkFlex(out, v, flagDraw);
        }
        out.flush();
        out.close();
    }

    protected void saveEPS(ViewSimple v, int w, int h, OutputStream o) throws Exception {
        PrintStream out = new PrintStream(o);
        EPSGraphics epsg = new EPSGraphics(out, "Aladin-chart", null, 0, 0, v.rv.width, v.rv.height);
        if (v.pref.active) {
            epsg.drawImage(v.getImage(w, h, false), 0, 0, v.aladin);
        }
        if (Projection.isOk(v.getProj())) {
            v.paintOverlays(epsg, null, 0, 0, true, 2);
        }
        v.drawCredit(epsg, 0, 0);
        epsg.end();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveMocAsAJS(String filename, PlanMoc p) {
        try (PrintWriter fo = null;){
            fo = new PrintWriter(new FileOutputStream(new File(filename)));
            String s = PlanMoc.createPerimeterString((SMoc)p.getMoc());
            fo.print("#AJS\ndraw line(" + s + ")\n");
            fo.close();
            fo = null;
        }
        return true;
    }

    protected boolean saveMoc(String filename, PlanMoc p, int format) {
        Moc moc = p.getMoc();
        try {
            if (moc instanceof SMoc && ((SMoc)moc).getMinOrder() > 0) {
                SMoc moc1 = (SMoc)moc.clone();
                moc1.setMinOrder(0);
                moc1.write(filename, format);
            } else {
                moc.write(filename, format);
            }
            this.aladin.memoLastFile(filename);
        }
        catch (Exception e) {
            if (Aladin.levelTrace > 3) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected boolean saveImageBMP(String filename, Plan p1) {
        PlanImage p = (PlanImage)p1;
        try {
            BMPWriter.write24BitBMP(((PlanRGBInterface)((Object)p)).getPixelsRGB(), p.width, p.height, new FileOutputStream(filename));
        }
        catch (Exception e) {
            System.out.println("!!! BMP image failed for \"" + filename + "\"");
            System.err.println(e + "");
            return false;
        }
        this.aladin.log("export", "BMP");
        return true;
    }

    protected boolean saveImage(String s, Plan p, int mode) {
        s = this.aladin.getFullFileName(s);
        File f = new File(s);
        boolean rep = mode >= 2 ? this.saveImageColor(s, (PlanImage)p, mode) : this.saveImageFITS(f, (PlanImage)p, mode);
        if (rep) {
            this.aladin.memoLastFile(s);
        }
        return rep;
    }

    public boolean saveImageColor(String filename, PlanImage p, int mode) {
        try {
            FileOutputStream o = new FileOutputStream(filename);
            boolean rep = this.saveImageColor(o, p, mode);
            if (rep) {
                this.aladin.log("export", mode == 3 ? "PNG" : "JPEG");
                this.aladin.memoLastFile(filename);
            }
            return rep;
        }
        catch (Exception e) {
            System.out.println("!!! " + (mode == 3 ? "PNG" : "JPEG") + " image failed");
            System.err.println(e + "");
            return false;
        }
    }

    protected boolean saveImageColor(OutputStream o, PlanImage p, int mode) {
        boolean flagJpeg = mode == 2;
        try {
            MemoryImageSource img = p.type == 2 ? new MemoryImageSource(p.width, p.height, p.cm, ((PlanRGBInterface)((Object)p)).getPixelsRGB(), 0, p.width) : new MemoryImageSource(p.width, p.height, p.cm, p.pixels, 0, p.width);
            String s = "Created by Aladin";
            if (!p.hasNoReduction()) {
                s = this.generateFitsHeaderStringForNativeImage(p);
            }
            if (flagJpeg) {
                BufferedImage imgBuf = new BufferedImage(p.width, p.height, 1);
                Graphics g = imgBuf.getGraphics();
                g.drawImage(this.getToolkit().createImage(img), 0, 0, null);
                g.finalize();
                g = null;
                this.ImageWriter(imgBuf, "jpg", -1.0f, p.type == 2, new JpegOutputFilter(o, s));
            } else {
                this.ImageWriter(this.getToolkit().createImage(img), "png", -1.0f, p.type == 2, new PNGOutputFilter(o, s));
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            System.out.println("!!! JPEG image failed");
            System.err.println(e + "");
            return false;
        }
        return true;
    }

    protected boolean saveImageFITS(File file, PlanImage p) {
        return this.saveImageFITS(file, p, 0);
    }

    protected boolean saveImageFITS(File file, PlanImage p, int mode) {
        boolean rep = false;
        try {
            if (file.exists() && !file.delete()) {
                throw new Exception("File already existing and not overwritable !");
            }
            FileOutputStream f = new FileOutputStream(file);
            if (mode == 0) {
                this.saveImageFITS(f, p);
            } else {
                this.saveImageHPX((OutputStream)f, p);
            }
            f.close();
            rep = true;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.errorFile = this.errorFile + "\n" + file;
        }
        this.aladin.log("export", "image FITS");
        return rep;
    }

    protected String generateFitsHeaderStringForNativeImage(PlanImage p) {
        Vector v = this.generateFitsHeader1(p.projInit, p.projd, p.headerFits, false, p.hasSpecificCalib(), false, false, 8, p.bZero, p.bScale, p.width, p.height);
        return this.fitsHeaderVtoStrings(v);
    }

    protected String generateFitsHeaderString(PlanImage p) {
        return this.fitsHeaderVtoStrings(this.generateFitsHeader(p));
    }

    protected String generateFitsHeaderString(ViewSimple v) {
        return this.fitsHeaderVtoStrings(this.generateFitsHeader(v));
    }

    private String fitsHeaderVtoStrings(Vector v) {
        StringBuffer s = new StringBuffer(v.size() * 80);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            byte[] b = (byte[])e.nextElement();
            s.append(new String(b).trim());
            s.append('\n');
        }
        return s.toString();
    }

    protected Vector generateFitsHeader(ViewSimple v) {
        Plan p = v.pref;
        Projection proj = Projection.isOk(p.projd) ? p.projd.copy() : null;
        int x = (int)Math.floor(v.rzoom.x);
        int y = (int)Math.floor(v.rzoom.y);
        int width = (int)Math.ceil(v.rzoom.width);
        int height = (int)Math.ceil(v.rzoom.height);
        double Zzoom = v.zoom;
        if (proj != null) {
            proj.cropAndZoom(x, y, width, height, Zzoom);
        }
        width = (int)Math.round(Zzoom * (double)width);
        height = (int)Math.round(Zzoom * (double)height);
        if (p instanceof PlanImage) {
            PlanImage pi = (PlanImage)p;
            return this.generateFitsHeader1(pi.projInit, proj, pi.headerFits, false, true, pi instanceof PlanImageRGB, pi instanceof PlanImageAlgo, pi.bitpix, pi.bZero, pi.bScale, width, height);
        }
        return this.generateFitsHeader1(p.projInit, proj, p.headerFits, false, true, p instanceof PlanImageRGB, p instanceof PlanImageAlgo, 8, 0.0, 1.0, width, height);
    }

    protected Vector generateFitsHeader(PlanImage p) {
        boolean flagTable = p.headerFits != null && p.headerFits.hasKey("TTYPE1");
        return this.generateFitsHeader1(p.projInit, p.projd, flagTable ? null : p.headerFits, p.hasOriginalPixels(), p.hasSpecificCalib(), p instanceof PlanImageRGB, p instanceof PlanImageAlgo, p.bitpix, p.bZero, p.bScale, p.width, p.height);
    }

    private Vector generateFitsHeader1(Projection projInit, Projection projd, FrameHeaderFits headerFits, boolean hasFitsPixels, boolean hasSpecificWCS, boolean imageRGB, boolean imageAlgo, int bitpix, double bZero, double bScale, int width, int height) {
        boolean hasNAXIS;
        Vector<byte[]> v = new Vector<byte[]>(100);
        Vector key = null;
        Vector value = null;
        Hashtable<String, String> qKey = null;
        boolean hasFitsHeader = headerFits != null;
        boolean hasNAXIS3 = imageRGB && hasFitsHeader && headerFits.hasKey("NAXIS3");
        boolean hasCTYPE3 = imageRGB && hasFitsHeader && headerFits.hasKey("CTYPE3");
        boolean hasBITPIX = hasFitsHeader && headerFits.hasKey("BITPIX");
        boolean bl = hasNAXIS = hasFitsHeader && headerFits.hasKey("NAXIS");
        if (hasSpecificWCS) {
            key = new Vector(20);
            value = new Vector(20);
            try {
                projd.getWCS(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            qKey = new Hashtable<String, String>(30);
            if (projInit != null) {
                Projection projection = projInit;
                String[] keyOmit = projection.c.getWCSKeys();
                for (int i = 0; i < keyOmit.length; ++i) {
                    String k2 = keyOmit[i].trim();
                    if (k2.equals("NAXIS1") || k2.equals("NAXIS2") || k2.equals("EPOCH")) continue;
                    qKey.put(k2, "");
                }
            }
            qKey.put("END", "");
        }
        if (!hasFitsHeader) {
            v.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
            v.addElement(Save.getFitsLine("BITPIX", (bitpix == 0 ? 8 : bitpix) + "", "Bits per pixel"));
            if (imageRGB) {
                v.addElement(Save.getFitsLine("NAXIS", "3", "Number of dimensions"));
                v.addElement(Save.getFitsLine("NAXIS1", "" + width, "Length of x axis"));
                v.addElement(Save.getFitsLine("NAXIS2", "" + height, "Length of y axis"));
                v.addElement(Save.getFitsLine("NAXIS3", "3", "Number of colors"));
            } else {
                v.addElement(Save.getFitsLine("NAXIS", "2", "Number of dimensions"));
                v.addElement(Save.getFitsLine("NAXIS1", "" + width, "Length of x axis"));
                v.addElement(Save.getFitsLine("NAXIS2", "" + height, "Length of y axis"));
            }
        } else {
            String k;
            int naxis = 2;
            try {
                naxis = headerFits.getIntFromHeader("NAXIS");
            }
            catch (Exception k2) {
                // empty catch block
            }
            boolean flagModif = false;
            Hashtable<String, String> origKeys = new Hashtable<String, String>(100);
            StringTokenizer st = new StringTokenizer(headerFits.getOriginalHeaderFits(), "\n");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.trim().length() == 0) {
                    v.addElement(Save.getFitsLineBlank());
                    continue;
                }
                k = HeaderFits.getKey(s);
                if (k != null) {
                    if (k.equals("COMMENT")) {
                        String s1 = s.substring(7).trim();
                        if (hasSpecificWCS && s1.equals(BYALADIN)) continue;
                        v.addElement(Save.getFitsLineComment(s1));
                        continue;
                    }
                    if (k.equals("HISTORY")) {
                        v.addElement(Save.getFitsLineHistory(s.substring(7).trim()));
                        continue;
                    }
                    origKeys.put(k, "");
                    if (k.equals("END")) continue;
                    if (k.equals("XTENSION")) {
                        v.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
                        continue;
                    }
                    if (!(!k.equals("SIMPLE") || hasBITPIX && hasNAXIS)) {
                        v.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
                        if (!hasBITPIX) {
                            v.addElement(Save.getFitsLine("BITPIX", (bitpix == 0 ? 8 : bitpix) + "", "Bits per pixel"));
                        }
                        if (hasNAXIS) continue;
                        v.addElement(Save.getFitsLine("NAXIS", "2", ""));
                        continue;
                    }
                    if (!imageRGB && k.equals("CTYPE3") && headerFits.getStringFromHeader(k).equals("RGB")) continue;
                    if (!hasFitsPixels || imageRGB) {
                        if (k.equals("SIMPLE")) {
                            v.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
                            continue;
                        }
                        if (k.equals("BITPIX")) {
                            v.addElement(Save.getFitsLine("BITPIX", "8", "Bits per pixel"));
                            continue;
                        }
                    }
                    if (imageAlgo) {
                        if (k.equals("BZERO")) {
                            v.addElement(Save.getFitsLine("BZERO", bZero + "", "Generated by Aladin (CDS)"));
                            continue;
                        }
                        if (k.equals("BSCALE")) {
                            v.addElement(Save.getFitsLine("BSCALE", bScale + "", "Generated by Aladin (CDS)"));
                            continue;
                        }
                        if (k.equals("BITPIX")) {
                            v.addElement(Save.getFitsLine("BITPIX", bitpix + "", "Bits per pixel"));
                            continue;
                        }
                    }
                    if (k.equals("EXTEND")) {
                        flagModif = true;
                        continue;
                    }
                    if (imageRGB && naxis != 3 && k.equals("NAXIS")) {
                        flagModif = true;
                        v.addElement(Save.getFitsLine("NAXIS", "3", ""));
                        continue;
                    }
                    if (hasSpecificWCS) {
                        if (k.equals("NAXIS1") && width != headerFits.getIntFromHeader(k)) {
                            v.addElement(Save.getFitsLine("NAXIS1", width + "", "Length of x axis"));
                            flagModif = true;
                            continue;
                        }
                        if (k.equals("NAXIS2") && height != headerFits.getIntFromHeader(k)) {
                            v.addElement(Save.getFitsLine("NAXIS2", height + "", "Length of y axis"));
                            flagModif = true;
                            continue;
                        }
                        if (hasSpecificWCS && qKey.get(k) != null) continue;
                    }
                    if (!(!imageRGB || hasNAXIS3 && hasCTYPE3)) {
                        if (!hasNAXIS3 && k.equals("NAXIS2")) {
                            v.addElement(this.getFullFitsLine(s));
                            v.addElement(Save.getFitsLine("NAXIS3", "3", "Number of colors"));
                            flagModif = true;
                            continue;
                        }
                        if (!hasCTYPE3 && k.equals("CTYPE2")) {
                            v.addElement(this.getFullFitsLine(s));
                            v.addElement(Save.getFitsLine("CTYPE3", "RGB", "Red Green Blue planes"));
                            flagModif = true;
                            hasCTYPE3 = true;
                            continue;
                        }
                    }
                }
                String valOrig = HeaderFits.getValue(s);
                String valC = headerFits.getHeaderFits().getHashHeader().get(k);
                if (valC == null) continue;
                if (Tok.unQuote(valC).trim().equals(valOrig.trim())) {
                    v.addElement(this.getFullFitsLine(s));
                    continue;
                }
                v.addElement(Save.getFitsLine(k, valC, "Aladin modif"));
            }
            if (hasFitsHeader) {
                Enumeration<String> e = headerFits.getHeaderFits().getHashHeader().keys();
                while (e.hasMoreElements()) {
                    k = e.nextElement();
                    if (origKeys.get(k) != null) continue;
                    v.addElement(Save.getFitsLine(k, headerFits.getHeaderFits().getHashHeader().get(k), "Aladin add"));
                }
            }
            if (flagModif) {
                v.addElement(Save.getFitsLineComment("Generated by Aladin (CDS)"));
            }
        }
        if (hasSpecificWCS) {
            v.addElement(Save.getFitsLineComment(BYALADIN));
            Enumeration ekey = key.elements();
            Enumeration evalue = value.elements();
            while (ekey.hasMoreElements()) {
                String skey = (String)ekey.nextElement();
                String svalue = (String)evalue.nextElement();
                if (skey.trim().equals("NAXIS1") || skey.trim().equals("NAXIS2") || skey.trim().equals("NAXIS3")) continue;
                v.addElement(Save.getFitsLine(skey, svalue, ""));
                if (!imageRGB || hasCTYPE3 || !skey.trim().equals("CTYPE2")) continue;
                v.addElement(Save.getFitsLine("CTYPE3", "RGB", "Red Green Blue planes"));
                hasCTYPE3 = true;
            }
        }
        if (imageRGB && !hasCTYPE3) {
            v.addElement(Save.getFitsLine("CTYPE3", "RGB", "Red Green Blue planes"));
        }
        return v;
    }

    protected InputStream saveImageFITS(OutputStream os, PlanImage p) throws Exception {
        byte[] bb;
        OutputStream f;
        MyByteArrayStream bas = null;
        int size = 0;
        if (os != null) {
            f = os;
        } else {
            bas = new MyByteArrayStream(10000);
            f = bas;
        }
        boolean hasFitsPixels = p.hasOriginalPixels();
        boolean hasFitsHeader = p.hasFitsHeader();
        boolean hasSpecificWCS = p.hasSpecificCalib();
        boolean imageRGB = p instanceof PlanImageRGB;
        Aladin.trace(3, "Export " + p.label + " (orig. Fits header:" + hasFitsHeader + ", orig. pixels:" + hasFitsPixels + ", specif.calib:" + hasSpecificWCS + ", RGB:" + imageRGB + ")");
        Vector v = this.generateFitsHeader(p);
        size = Save.writeFitsLines(f, v, size);
        byte[] end = Save.getEndBourrage(size);
        f.write(end);
        size += end.length;
        if (imageRGB) {
            size = 0;
            PlanImageRGB pRGB = (PlanImageRGB)p;
            int n = pRGB.width * pRGB.height;
            byte[] buf = new byte[n];
            for (int i = 0; i < 3; ++i) {
                pRGB.getColor(buf, i);
                PlanImageRGB.invImageLine(pRGB.width, pRGB.height, buf);
                f.write(buf);
                size += n;
            }
        } else {
            bb = hasFitsPixels ? p.getFitsPixels() : p.getFits8Pixels();
            f.write(bb);
            size = bb.length;
        }
        if (size % 2880 != 0) {
            int bourrage = 2880 - size % 2880;
            bb = new byte[bourrage];
            f.write(bb);
        }
        if (bas == null) {
            return null;
        }
        return bas.getInputStream();
    }

    public static Vector generateHealpixHDU0(boolean flagColor) {
        Vector<byte[]> v = new Vector<byte[]>(100);
        v.addElement(Save.getFitsLine("SIMPLE", "T", "conforms to FITS standard"));
        v.addElement(Save.getFitsLine("BITPIX", "8", "array data type"));
        v.addElement(Save.getFitsLine("NAXIS", "0", "number of array dimensions"));
        v.addElement(Save.getFitsLine("EXTEND", "T", null));
        if (flagColor) {
            v.addElement(Save.getFitsLine("COLORMOD", "ARGB", null));
        }
        return v;
    }

    public static Vector generateHealpixHDU1(int norder, int bitpix, boolean ring, int lenLine, int frame) {
        return Save.generateHealpixHDU1(norder, bitpix, ring, lenLine, frame, Double.NaN);
    }

    public static Vector generateHealpixHDU1(int norder, int bitpix, boolean ring, int lenLine, int frame, double badData) {
        Vector<byte[]> v = new Vector<byte[]>(100);
        long nside = CDSHealpix.pow2(norder);
        long nbPix = 12L * nside * nside;
        int npix = Math.abs(bitpix) / 8;
        lenLine = 1;
        String tForm = bitpix == 8 ? "I" : (bitpix == 16 ? "I" : (bitpix == 32 ? "J" : (bitpix == -32 ? "E" : "D")));
        v.addElement(Save.getFitsLine("XTENSION", "BINTABLE", "binary table extension"));
        v.addElement(Save.getFitsLine("BITPIX", "8", "array data type"));
        v.addElement(Save.getFitsLine("NAXIS", "2", "2-dimensional binary table"));
        v.addElement(Save.getFitsLine("NAXIS1", lenLine * npix + "", "width of table"));
        v.addElement(Save.getFitsLine("NAXIS2", nbPix / (long)lenLine + "", "number of rows in table"));
        v.addElement(Save.getFitsLine("PCOUNT", "0", "number of group parameters"));
        v.addElement(Save.getFitsLine("GCOUNT", "1", "number of groups"));
        v.addElement(Save.getFitsLine("TFIELDS", "1", "number of table fields"));
        v.addElement(Save.getFitsLine("TTYPE1", "PIXVAL", "label for field   1"));
        v.addElement(Save.getFitsLine("TFORM1", lenLine + tForm, "data format of field"));
        v.addElement(Save.getFitsLine("PIXTYPE", "HEALPIX", "Pixel algorithm"));
        v.addElement(Save.getFitsLine("ORDERING", ring ? "RING" : "NESTED", "Ordering scheme"));
        v.addElement(Save.getFitsLine("NSIDE", nside + "", "Resolution parameter"));
        v.addElement(Save.getFitsLine("FIRSTPIX", "0", "First pixel (0 based)"));
        v.addElement(Save.getFitsLine("LASTPIX", nbPix - 1L + "", "Last pixel (0 based)"));
        if (frame != 3) {
            v.addElement(Save.getFitsLine("COORDSYS", frame == 2 ? "E" : (frame == 3 ? "G" : "C"), "Coordinate system"));
        }
        if (!Double.isNaN(badData)) {
            v.addElement(Save.getFitsLine("BAD_DATA", badData + "", "Sentinel value given for bad pixels"));
        }
        return v;
    }

    public static int writeFitsLines(OutputStream f, Vector v, int size) throws Exception {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            byte[] b = (byte[])e.nextElement();
            f.write(b);
            size += b.length;
        }
        return size;
    }

    protected InputStream saveImageHPX(OutputStream os, PlanBG p) throws Exception {
        MyByteArrayStream bas = null;
        int size = 0;
        try {
            OutputStream f;
            if (os != null) {
                f = os;
            } else {
                bas = new MyByteArrayStream(10000);
                f = bas;
            }
            int N = 9;
            int losangeWidth = Util.nside(N);
            int order = N + 3;
            int bitpix = p.bitpix;
            int nbits = Math.abs(bitpix) / 8;
            long nside = CDSHealpix.pow2(order);
            long nbPix3 = 768L;
            boolean ring = false;
            int lenLine = 1024;
            Aladin.trace(3, "Export " + p.label + "\" in healpix NSIDE=" + nside + " [" + (ring ? "RING" : "NESTED") + "] bitpix=" + bitpix);
            Vector v = Save.generateHealpixHDU0(false);
            size = Save.writeFitsLines(f, v, size);
            byte[] end = Save.getEndBourrage(size);
            f.write(end);
            size += end.length;
            v = Save.generateHealpixHDU1(order, bitpix, ring, lenLine, p.getFrameOrigin());
            size = Save.writeFitsLines(f, v, size);
            end = Save.getEndBourrage(size);
            f.write(end);
            size += end.length;
            Projection proj = p.projd;
            Coord c = new Coord();
            byte[] buf = new byte[lenLine * nbits];
            int pos = 0;
            int nbPix = losangeWidth * losangeWidth;
            this.nan = new byte[nbPix * nbits];
            for (int i = 0; i < nbPix; ++i) {
                PlanImage.setPixVal(this.nan, bitpix, i, Double.NaN);
            }
            int[] hpx2xy = Util.createHpx2xy(N);
            int i = 0;
            while ((long)i < nbPix3) {
                boolean found = true;
                String filename = Util.getFilePath(p.url, order - N, (long)i);
                Fits los = new Fits();
                try {
                    los.loadFITS(filename + ".fits");
                }
                catch (FileNotFoundException e) {
                    found = false;
                }
                if (!found) {
                    f.write(buf, 0, pos);
                    size += pos;
                    pos = 0;
                    f.write(this.nan);
                    pos = 0;
                    size += this.nan.length;
                    p.pourcent = 100.0 * (double)i / (double)nbPix3;
                } else {
                    for (int ipix = 0; ipix < nbPix; ++ipix) {
                        int idx = hpx2xy[ipix];
                        int yy = idx / losangeWidth;
                        int xx = idx - yy * losangeWidth;
                        double val = los.getPixelDouble(xx, yy);
                        PlanImage.setPixVal(buf, bitpix, pos++, val);
                        if (pos != lenLine) continue;
                        f.write(buf);
                        pos = 0;
                        size += buf.length;
                        p.pourcent = 100.0 * (double)i / (double)nbPix3;
                    }
                }
                ++i;
            }
            if (pos > 0) {
                f.write(buf, 0, pos);
                size += pos;
            }
            if (size % 2880 != 0) {
                int bourrage = 2880 - size % 2880;
                byte[] bb = new byte[bourrage];
                f.write(bb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        p.pourcent = -1.0;
        p.setLockCacheFree(false);
        if (bas == null) {
            return null;
        }
        return bas.getInputStream();
    }

    protected InputStream saveImageHPX(OutputStream os, PlanImage p) throws Exception {
        if (p instanceof PlanBG) {
            return this.saveImageHPX(os, (PlanBG)p);
        }
        MyByteArrayStream bas = null;
        int size = 0;
        boolean flagColor = p instanceof PlanImageRGB;
        try {
            OutputStream f;
            if (os != null) {
                f = os;
            } else {
                bas = new MyByteArrayStream(10000);
                f = bas;
            }
            int order = 10;
            int bitpix = flagColor ? 32 : (p.bitpix == 8 ? 16 : p.bitpix);
            int npix = Math.abs(bitpix) / 8;
            long nside = CDSHealpix.pow2(order);
            long nbPix = 12L * nside * nside;
            boolean ring = false;
            int lenLine = 1024;
            Aladin.trace(3, "Export " + p.label + "\" in healpix NSIDE=" + nside + " [" + (ring ? "RING" : "NESTED") + "] bitpix=" + bitpix + (flagColor ? " ARGB" : ""));
            Vector v = Save.generateHealpixHDU0(flagColor);
            size = Save.writeFitsLines(f, v, size);
            byte[] end = Save.getEndBourrage(size);
            f.write(end);
            size += end.length;
            v = Save.generateHealpixHDU1(order, bitpix, ring, lenLine, 0);
            size = Save.writeFitsLines(f, v, size);
            end = Save.getEndBourrage(size);
            f.write(end);
            size += end.length;
            Projection proj = p.projd;
            Coord c = new Coord();
            byte[] buf = new byte[lenLine * npix];
            int pos = 0;
            p.pourcent = 1.0;
            p.setLockCacheFree(true);
            p.pixelsOriginFromCache();
            for (long ipix = 0L; ipix < nbPix; ++ipix) {
                double[] polar = CDSHealpix.pix2ang_nest(order, ipix);
                double[] radec = CDSHealpix.polarToRadec(polar);
                c.al = radec[0];
                c.del = radec[1];
                c = Localisation.frameToFrame(c, p.projd.frame, 0);
                proj.getXY(c);
                if (!flagColor) {
                    double val = Double.isNaN(c.x) || c.x < -1.0 || c.x > (double)(p.width + 1) || c.y < -1.0 || c.y > (double)(p.height + 1) ? Double.NaN : p.getPixelInDouble((int)c.x, (int)c.y);
                    PlanImage.setPixVal(buf, bitpix, pos++, val);
                } else {
                    int val = Double.isNaN(c.x) || c.x < 0.0 || c.x > (double)p.width || c.y < 0.0 || c.y > (double)p.height ? 0 : p.getPixel8((int)c.x, (int)c.y);
                    PlanImage.setInt(buf, pos * 4, val);
                    ++pos;
                }
                if (pos != lenLine) continue;
                f.write(buf);
                pos = 0;
                size += buf.length;
                p.pourcent = 100.0 * (double)ipix / (double)nbPix;
            }
            if (pos > 0) {
                f.write(buf, 0, pos);
                size += pos;
            }
            if (size % 2880 != 0) {
                int bourrage = 2880 - size % 2880;
                byte[] bb = new byte[bourrage];
                f.write(bb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        p.pourcent = -1.0;
        p.setLockCacheFree(false);
        if (bas == null) {
            return null;
        }
        return bas.getInputStream();
    }

    public static byte[] getFitsLineBlank() {
        byte[] b = new byte[80];
        for (int i = 0; i < b.length; ++i) {
            b[i] = 32;
        }
        return b;
    }

    public static byte[] getFitsLineComment(String comment) {
        return Save.getFitsLine("COMMENT", null, comment);
    }

    public static byte[] getFitsLineHistory(String history) {
        return Save.getFitsLine("HISTORY", null, history);
    }

    private static char[] formatFitsString(char[] a) {
        int i;
        if (a.length == 0) {
            return a;
        }
        StringBuffer s = new StringBuffer();
        boolean flagQuote = a[0] == '\'';
        s.append('\'');
        for (i = flagQuote ? 1 : 0; i < a.length - (flagQuote ? 1 : 0); ++i) {
            if (!flagQuote && a[i] == '\'') {
                s.append('\'');
            }
            s.append(a[i]);
        }
        while (i < (flagQuote ? 9 : 8)) {
            s.append(' ');
            ++i;
        }
        s.append('\'');
        return s.toString().toCharArray();
    }

    private static boolean isFitsString(String s) {
        if (s.length() == 0) {
            return true;
        }
        char c = s.charAt(0);
        if (s.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+' && c != 'E' && c != 'e') {
            return true;
        }
        c = s.charAt(s.length() - 1);
        if (!Character.isDigit(c)) {
            return true;
        }
        try {
            Double.parseDouble(s);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static byte[] getEndBourrage(int headSize) {
        int size = 2880 - headSize % 2880;
        if (size < 3) {
            size += 2880;
        }
        byte[] b = new byte[size];
        b[0] = 69;
        b[1] = 78;
        b[2] = 68;
        for (int i = 3; i < b.length; ++i) {
            b[i] = 32;
        }
        return b;
    }

    public static byte[] getFitsLine(String key, String value, String comment) {
        int i;
        byte[] b = new byte[80];
        char[] a = key.toCharArray();
        int j = 0;
        for (i = 0; i < 8; ++i) {
            b[i] = (byte)(j < a.length ? a[j] : 32);
            ++j;
        }
        if (value != null) {
            b[i++] = 61;
            b[i++] = 32;
            a = value.toCharArray();
            if (!Save.isFitsString(value)) {
                for (j = 0; j < 20 - a.length; ++j) {
                    b[i++] = 32;
                }
                for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                    b[i] = (byte)a[j];
                }
            } else {
                a = Save.formatFitsString(a);
                for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                    b[i] = (byte)a[j];
                }
                while (i < 30) {
                    b[i++] = 32;
                }
            }
        }
        if (comment != null && comment.length() > 0 && i < 77) {
            if (value != null) {
                b[i++] = 32;
                b[i++] = 47;
                b[i++] = 32;
            }
            a = comment.toCharArray();
            for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                b[i] = (byte)a[j];
            }
        }
        while (i < 80) {
            b[i++] = 32;
        }
        return b;
    }

    protected byte[] getFullFitsLine(String s) {
        int i;
        byte[] b = new byte[80];
        char[] a = s.toCharArray();
        for (i = 0; i < a.length && i < 80; ++i) {
            b[i] = (byte)a[i];
        }
        while (i < 80) {
            b[i++] = 32;
        }
        return b;
    }

    protected static String getTSV(Source o) {
        return Save.getSourceInfo(o, "\t");
    }

    protected static String getInfo(Source o) {
        return Save.getSourceInfo(o, " / ");
    }

    protected static String getSourceInfo(Source o, String sep) {
        StringBuilder s = new StringBuilder();
        StringTokenizer st = new StringTokenizer(o.info, "\t");
        st.nextElement();
        while (st.hasMoreTokens()) {
            Words w = new Words(st.nextToken(), -1);
            if (s.length() != 0) {
                s.append(sep);
            }
            s.append(w.getText());
        }
        return s.toString();
    }

    protected static String getJSON(Legende leg, Source o) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        s.append("{ ");
        String[] values = o.getValues();
        for (int i = 0; i < leg.field.length; ++i) {
            Field f = leg.field[i];
            if (!f.visible) continue;
            if (!first) {
                s.append(", ");
            }
            s.append("\"" + cds.tools.Util.escapeJSON(f.name) + "\": \"" + cds.tools.Util.escapeJSON(values[i]) + "\"");
            first = false;
        }
        s.append(" }");
        return s.toString();
    }

    protected String getShortHeader(Legende leg) {
        int i;
        StringBuffer s = new StringBuffer();
        for (i = 0; i < leg.field.length; ++i) {
            if (i > 0) {
                s.append("\t");
            }
            s.append(leg.field[i].name);
        }
        s.append(CR);
        for (i = 0; i < leg.field.length; ++i) {
            int j;
            if (i > 0) {
                s.append("\t");
            }
            try {
                j = Integer.parseInt(leg.field[i].width);
            }
            catch (Exception e) {
                j = 0;
            }
            if (j == 0) {
                j = 10;
            }
            for (int k = 0; k < j; ++k) {
                s.append("-");
            }
        }
        s.append(CR);
        return s.toString();
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (CHOICE[0].equals(what)) {
            this.saveFile(1, Save.getCodedFormat(this.format.getSelectedIndex()), -1.0f);
        } else if (CHOICE[2].equals(what)) {
            this.saveFile(0);
        } else if (CHOICE[1].equals(what)) {
            this.exportPlans();
        } else if (Aladin.BETA && CHOICE[3].equals(what)) {
            this.saveFile(2, Save.getCodedFormat(this.format1.getSelectedIndex()), -1.0f);
        } else if (evt.target instanceof Checkbox && this.tsvCb != null) {
            this.changeCatFormat();
        } else if (evt.target instanceof Checkbox && this.fitsCb != null) {
            this.changeImgFormat();
        } else if (evt.target instanceof Checkbox && this.fitsMocCb != null) {
            this.changeMocFormat();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButton) {
            if (this.tsvCb != null) {
                this.changeCatFormat();
            }
            if (this.fitsCb != null) {
                this.changeImgFormat();
            }
            if (this.fitsMocCb != null) {
                this.changeMocFormat();
            }
        }
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            this.hide();
        }
        return super.handleEvent(e);
    }

    static {
        MAXBUF = 8192;
        buf = new byte[MAXBUF];
        nbuf = 0;
        B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        b642a = null;
    }

    class JpegOutputFilter
    extends OutputStream {
        OutputStream out;
        String comment;
        boolean first;
        private final byte[] buf = new byte[4];

        JpegOutputFilter(OutputStream out, String comment) {
            this.out = out;
            this.comment = comment;
            this.first = true;
        }

        private void insertComment() throws IOException {
            this.buf[0] = -1;
            this.buf[1] = -2;
            int len = this.comment.length();
            this.buf[2] = (byte)(len + 2 >> 8 & 0xFF);
            this.buf[3] = (byte)(len + 2 & 0xFF);
            this.out.write(this.buf, 0, 4);
            this.out.write(this.comment.getBytes(), 0, len);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.first && len < 2) {
                this.first = false;
            }
            if (this.first) {
                this.out.write(b, off, 2);
                this.insertComment();
                this.first = false;
                if (len - 2 > 0) {
                    this.out.write(b, off + 2, len - 2);
                }
            } else {
                this.out.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.buf[0] = (byte)(b >> 24 & 0xFF);
            this.buf[1] = (byte)(b >> 16 & 0xFF);
            this.buf[2] = (byte)(b >> 8 & 0xFF);
            this.buf[3] = (byte)(b & 0xFF);
            this.write(this.buf, 0, 4);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.close();
        }
    }

    class PNGOutputFilter
    extends OutputStream {
        OutputStream out;
        byte[] comment;
        boolean writeComment = false;
        CRC32 crc = new CRC32();
        private final byte[] buf = new byte[8];
        private int mode = 0;
        private int offset = 0;
        private int sizeHeader = 0;
        private int header = 0;

        PNGOutputFilter(OutputStream out, String s) {
            this.out = out;
            int n = s.length();
            this.comment = new byte[n + 12];
            for (int i = 0; i < "tEXtComment".length(); ++i) {
                this.comment[i] = (byte)"tEXtComment".charAt(i);
            }
            this.comment[11] = 0;
            System.arraycopy(s.getBytes(), 0, this.comment, 12, n);
        }

        private void insertComment() throws IOException {
            int len = this.comment.length - 4;
            this.buf[0] = (byte)(len >> 24 & 0xFF);
            this.buf[1] = (byte)(len >> 16 & 0xFF);
            this.buf[2] = (byte)(len >> 8 & 0xFF);
            this.buf[3] = (byte)(len & 0xFF);
            this.out.write(this.buf, 0, 4);
            this.out.write(this.comment, 0, this.comment.length);
            this.crc.reset();
            this.crc.update(this.comment);
            long c = this.crc.getValue();
            this.buf[0] = (byte)(c >> 24 & 0xFFL);
            this.buf[1] = (byte)(c >> 16 & 0xFFL);
            this.buf[2] = (byte)(c >> 8 & 0xFFL);
            this.buf[3] = (byte)(c & 0xFFL);
            this.out.write(this.buf, 0, 4);
        }

        private int endOfHeader(byte[] b, int off, int len) {
            int i = 0;
            while (i < len) {
                switch (this.mode) {
                    case 0: {
                        if (this.offset != 7) break;
                        this.mode = 1;
                        break;
                    }
                    case 1: {
                        this.sizeHeader = this.sizeHeader << 8 | b[off + i] & 0xFF;
                        if (this.offset != 11) break;
                        this.mode = 2;
                        break;
                    }
                    case 2: {
                        ++this.header;
                        if (this.header != this.sizeHeader + 8) break;
                        return i + 1;
                    }
                }
                ++i;
                ++this.offset;
            }
            return -1;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.writeComment) {
                int fold = this.endOfHeader(b, off, len);
                if (fold >= 0) {
                    this.out.write(b, off, fold);
                    this.insertComment();
                    this.out.write(b, off + fold, len - fold);
                    this.writeComment = true;
                } else {
                    this.out.write(b, off, len);
                }
            } else {
                this.out.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.buf[0] = (byte)(b >> 24 & 0xFF);
            this.buf[1] = (byte)(b >> 16 & 0xFF);
            this.buf[2] = (byte)(b >> 8 & 0xFF);
            this.buf[3] = (byte)(b & 0xFF);
            this.write(this.buf, 0, 4);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

